(defmeth reliability-model-object-proto :visualize ()
  (let* (
         (data (send self :data))
         (scale (send self :scale))
         (scaleq (mapcar #'(lambda (x) 
                 (cond
                     (  (< x (quantile scale .20))  1)
                     (  (and (>= x (quantile scale .20)) (< x (quantile scale .4))) 2)
                     (  (and (>= x (quantile scale .40)) (< x (quantile scale .60))) 3)
                     (  (and (>= x (quantile scale .60)) (< x (quantile scale .80))) 4)
                     (  (>= x (quantile scale .80))  5)))
                      scale))
         (scale-if (send self :scale-if))
         (dialog-value (send self :dialog-value))
         (alfa-original (send self :alfa))
         (alfa-if (send self :alfa-if))
         (scale-variance-if (send self :scale-variance-if))
         (split-original (send self :split-half))
         (n-items (send self :n-items))
         (item-labels (send self :variables))
         (nobs (send self :nobs))
         (labels (send self :labels))
         (scale-pares (send self :scale-pares))
         (scale-impares (send self :scale-impares))
         (eign (send self :eign))
         (eigenvalues (send self :eigenvalues))
         (n (if (= dialog-value 6) 
                (send self :NUM-FACTORS)
                (length eigenvalues)))
        
         (prop (if (= dialog-value 6) (/ (send self :e-axis) (sum (send self  :e-axis)))
                (/ eigenvalues (sum eigenvalues))))         
         (maxy (select prop 0))
         (cum-prop (cumsum prop))
         (eigenvalues2 
          (mapcar #'(lambda (k)
                      (exp  (+ 
                             -0.130827
                             (* -0.444853 k)
                             (* -0.008497 (* k k)) 
                             (* 0.639462 (log n-items))
                             (* (* 0.059901 k) (log Nobs))
                             (* -0.078631 (* (log Nobs) (log n-items)))
                             (* (* 0.001488 (* k k)) (log Nobs))
                             (* (* 0.095875 k) (log n-items))
                             (* (* 0.001576 (* k k)) (log n-items))
                             (* (* -0.013331 k) (* (log Nobs) (log n-items)))
                             (* (* -0.000278 (* k k)) (* (log Nobs) (log n-items)))
                             ))) (iseq n)))
         (prop2 (/ eigenvalues2 (sum eigenvalues2)))
         (maxy2 (select prop2 0))
         (cum-prop2 (cumsum prop2))
         (theta (send self :theta)) 



         (SplitLabel (list "Even-Items" "Uneven-Items"))
         (item-corr-matrix (correlation-matrix data))
(average-corr-original (/ (- (sum item-corr-matrix) n-items) ( - (* n-items n-items) n-items)))
         (rel-pronostico (mapcar #'(lambda (x) (* X (/ alfa-original  (+ 1 (* (- X 1) alfa-original))))) (rseq 1 5 50)))
         (theta-function (mapcar #'(lambda (x)  (* (/ n-items (- n-items 1)) (- 1 (/ 1 x))) ) (rseq 1 n-items 50)))
         (Alfa-ifP (plot-points (iseq 1 n-items) alfa-if
             :title "Alpha if Item deleted" :variable-labels (list "Item" "Alpha if Item deleted") :point-labels item-labels :show nil))

          (Scree (plot-points (+ 1 (iseq n)) prop
                :show nil :title "Scree Plot"
                :variable-labels '("Princ Component" "Proportion")))

         (p (plot-lines
                 (rseq 1 n-items 50) theta-function
                      :title "Theta Plot"
                :variable-labels (list "First PCA Eigenvalue" "Reliability")
                      :show nil))
        
         (plot (plot-lines
                 (rseq 1 5 50) rel-pronostico
                      :title "S-B Prophecy Curve"
                :variable-labels (list "n times incress" "Test Reliability")
                      :show nil))

         (itemlist (name-list item-labels
                     :title "Items List" 
                     :show nil))        

         (histscale (histogram scale
                                     :title "Test Score Histogram"    
                                     :variable-labels (list "Test Score")
                               :show nil))

         (itembox (boxplot data 
                             :title "Items Boxplot"
                             :variable-labels item-labels
                             :point-labels  labels
                             :connect-points t :show nil))

         (scalebox (boxplot scale 
                             :title "Test Score Boxplot"
                             :variable-labels (list "Total Score")
                             :point-labels  labels
                             :connect-points t :show nil))

         (ObsList (name-list labels :show nil))


         (SplitScat (plot-points scale-pares scale-impares
                            :point-labels  labels
                             :variable-labels SplitLabel :show nil))

         (split-box (boxplot (list scale-pares scale-impares) :title "Split Half Box"
                             :point-labels  labels
                             :variable-labels SplitLabel
                             :connect-points t
                             :show nil))

         (NqPlot (quantile-plot scale
                                :title "Normal probability plot for Test Score"
                                :point-labels  nil
                                :show nil ))

         (CCIbox (boxplot (mapcar #'(lambda (q)
                                    (mapcar #'mean (column-list (make-array (list (length (which (= q scaleq))) n-items) :initial-contents (COMBINE (select (row-list data) (which (= q scaleq)))))))
             )  (sort-data (remove-duplicates  scaleq :test #'equal)))
                           :title "CCIbox" 
                          :connect-points t
                          :Y-AXIS-LABEL "Item mean"                                                   
                           :variable-labels (list "<Perc20" "Perc20-39" "Perc40-59" "Perc60-79" "Perc>=80")                   
                          :point-labels item-labels 
                          :show nil))
     

         (varlist (name-list item-labels
                     :title "Items List" 
                     :show nil))        

         (item-dif&dis (plot-points (send self :ITEM-MEANs)
                                        (if (= dialog-value 6)
                                            (send self :CORRECTED-POINT-BIS-CORR)
                                        (mapcar #'(lambda (x) (correlation x scale)) (column-list  data)))
                                    :point-labels item-labels 
                                    :variable-labels (list "Location" "Discrimination")
                                    :show nil))

         (ItemMean (plot-points (send self :ITEM-MEANs) (send self :item-variances)
                                :point-labels item-labels
                                :variable-labels (list "Item-Mean" "Item-Var")
                                :show nil))
                    
         (sp  
          (cond 

            ((= dialog-value 0) 
                 (spread-plot (matrix '(2 3) (list itemlist ItemMean ObsList itembox nil nil))  :rel-widths (list 0.5 1 0.5) :span-right (matrix (list 2 3) (list 1 1 1 4 0 0)))
                 )
            ((= dialog-value 1)
                 (spread-plot (matrix '(2 3) (list itemlist histscale scalebox ObsList NqPlot nil)) :rel-widths (list 0.5 1 0.5) :span-down (matrix (list 2 3) (list 1 1 2 1 1 0)))
                 )
            ((or (= dialog-value 2) (= dialog-value 6))
             (spread-plot (matrix '(2 4) (list itemlist histscale nil ObsList CCIbox  nil item-dif&dis nil)) :rel-widths (list 0.5 0.5 0.5 0.5) :span-right (matrix (list 2 4) (list 1 2 0 1 2 0 2 0)))
                 )            

            ((= dialog-value 3)
                 (spread-plot (matrix '(2 4) (list  itemlist plot histscale ObsList nil itembox Alfa-ifP nil)) 
                              :rel-widths (list 0.5 1.5 1 0.5) :span-down (matrix (list 2 4) (list 2 1 1 2 0 1 1 0)))
                 )
                
            ((= dialog-value 4)
                 (spread-plot (matrix '(2 4) (list  itemlist plot histscale  ObsList  nil split-box SplitScat nil )) :rel-widths (list 0.5 1.5 1 0.5) :span-down (matrix (list 2 4) (list 2 1 1 2 0 1 1 0)))
                 )

                 (
                  (= dialog-value 5)
                 (spread-plot 
                      (matrix '(2 4)
                          (list  itemlist p histscale  ObsList nil itembox Scree nil )) 
               :rel-widths (list 0.5 1.5 1 0.5) :span-down (matrix (list 2 4) (list 2 1 1 2 0 1 1 0))
               )
                 )

           
            )
          )
         )
(make-color 'bl  0.40 0.40 0.40)

;*some-general
    
    (mapcar #'(lambda (plots) (send plots :use-color t))
             (list item-dif&dis ItemMean Alfa-ifP p plot ObsList itemlist histscale varlist SplitScat))

     (mapcar #'(lambda (plots)  (send plots 
                                      :plot-buttons 
                                      :new-x nil 
                                      :new-y nil 
                                      :mouse-mode t)) 
             (list item-dif&dis Alfa-ifP  ItemMean NqPlot p plot histscale SplitScat))

   (mapcar #'(lambda (boxs) (send boxs :use-color t)
               (send boxs :linked t)
               (send boxs :showing-labels t)
               (send boxs :mouse-mode 'brushing))
           (list split-box CCIbox scalebox itembox  ))

;*item-dif&dis
    (send item-dif&dis :showing-labels t) 
    (send item-dif&dis :point-color (iseq n-items) 'blue)
    (send item-dif&dis :new-menu "ItemMeans" :items '(MOUSE SYMBOL))

;*ItemMean
    (send ItemMean :showing-labels t) 
    (send ItemMean :point-color (iseq n-items) 'blue)
    (send ItemMean :new-menu "ItemMeans" :items '(MOUSE SYMBOL))
  
;*Alfa-ifP
(send Alfa-ifP :x-axis t t (+ 1 n-items))
(send Alfa-ifP :y-axis 0 1 6)
(send Alfa-ifP :range 1 0 1)
(send Alfa-ifP :range 0 0 n-items)

    (send Alfa-ifP :new-menu "Alpha-if" 
              :items '(MOUSE))
 (send Alfa-ifP :showing-labels t) 
 (send Alfa-ifP :point-color (iseq n-items) 'blue)
 (send Alfa-ifP :abline alfa-original 0)

;*SCREE

                (send Scree :range 1 0  (* .1 (ceiling (* 10 maxy))) :draw nil)
                (send Scree :y-axis t t (1+   (ceiling (* 10 maxy))) :draw t)
                (send Scree :plot-buttons :new-x nil :new-y nil :mouse-mode t)
                (send Scree :showing-labels t)
                (send Scree :mouse-mode 'brushing)
                (send Scree :menu nil)
                (send Scree :point-state 0 'selected)
                (send Scree :adjust-to-data :draw nil)
                
    (send Scree :add-lines 
          (list (+ 1 (iseq n)) prop) :draw nil :color 'red)
    (send Scree :point-color (iseq n) 'red)
    
    (if (= dialog-value 5)
        (send Scree :add-lines 
              (list (+ 1 (iseq n)) prop2) :draw nil :color 'dark-green)    
        (send Scree :point-color (iseq n) 'red))
    
    (mapcar #'(lambda (i)
                 (send Scree :point-label i
                       (cond
                         ((> i 0) 
                          (format nil "~5,4f, ~5,4f, ~5,4f" 
                                  (select prop i) 
                                  (- (select prop (- i 1)) (select prop i) )
                                  (select cum-prop i)))
                         (t
                          (format nil "~5,4f" (select prop i))))))
            (iseq (send Scree :num-points)))


;*p
(send p :abline theta 0 )
(send p :range 0 1 n-items)
(send p :x-axis t t n-items)
(send p :new-menu "Theta-Plot" 
              :items '(MOUSE))

;*NqPlot


(send NqPlot :new-menu "NQPlot" 
              :items '(MOUSE))

;*plot
(send plot :abline alfa-original 0)
(send plot :x-axis t t 5)
(send plot :y-axis t t 6)
(send plot :range 1 0 1)
(send plot :range 0 1 5)
(send plot :new-menu "SP-Plot" :items '(MOUSE))


;*ObsList

    (send ObsList :point-color (iseq nobs) 'blue)
    (send ObsList :new-menu "Obs List" :items '(MOUSE  DASH SYMBOL COLOR))
    (send ObsList :linked t)

;*SplitScat
    (send SplitScat :linked t)
    (send SplitScat :point-color (iseq nobs) 'blue)
    (send SplitScat :adjust-to-data)
    (send (send SplitScat :menu) :title "SplitScat")
    (send SplitScat :plot-buttons)
    (send SplitScat :showing-labels t)
    (send SplitScat :mouse-mode 'brushing)
    (send SplitScat :menu-template '(SHOWING-LABELS MOUSE RESIZE-BRUSH DASH SYMBOL COLOR RAY-LINE-WIDTH ))

;*split-box
    (send split-box :new-menu "Split Half Box" :items '(SHOWING-LABELS MOUSE RESIZE-BRUSH DASH SYMBOL COLOR))
    (send split-box :linked t)
    (send split-box :showing-labels t)


;*CCIbox
    (send CCIbox :new-menu "CCI Box" :items '(SHOWING-LABELS MOUSE RESIZE-BRUSH DASH SYMBOL COLOR))  


;*varlist
    (send varlist :linked t)
    (send varlist :point-color (iseq n-items) 'blue)

;*scalebox
    (send scalebox :new-menu "Total score Box plot" :items '(SHOWING-LABELS MOUSE RESIZE-BRUSH DASH SYMBOL COLOR))
    (send scalebox :linked t)

   
   
;*itembox
    (send itembox :new-menu "ItemsBox" :items '(SHOWING-LABELS MOUSE RESIZE-BRUSH DASH SYMBOL COLOR))


*;varlist
    (send varlist :linked t)
    (send varlist :use-color t)  
    (send varlist :point-color (iseq n-items) 'blue)
;*histscale
    (send histscale :title "Test Score Distribution Plot")
  (send histscale :point-color (iseq  nobs) 'blue)
  (send histscale :linked t)
     (send histscale :mouse-mode 'brushing)
  (send histscale :point-color (iseq  nobs) 'blue)

;*itemlist 
    (send itemlist :point-color (iseq n-items) 'blue)
    (send itemlist :new-menu "Item List" :items '(MOUSE  DASH SYMBOL COLOR))
   
    (defmeth itemlist :do-select-click (&rest args)
      (apply #'call-next-method args)
      (when (send itemlist :selection)
            (let* (
                   (selection (send itemlist :selection)))         
              (let* (
                     (data1 (select (column-list  (send current-data :active-data-matrix '(numeric)))  selection))
                     (data2 (combine data1))
                     (data (transpose (make-array (list (length selection) nobs ) :initial-contents (list data2))))
                     (scale (mapcar #'sum (row-list data)))  
                     (scaleq (mapcar #'(lambda (x) 
                                         (cond
                                           (  (< x (quantile scale .20))  1)
                                           (  (and (>= x (quantile scale .20)) (< x (quantile scale .4))) 2)
                                           (  (and (>= x (quantile scale .40)) (< x (quantile scale .60))) 3)
                                           (  (and (>= x (quantile scale .60)) (< x (quantile scale .80))) 4)
                                           (  (>= x (quantile scale .80))  5)))
                                     scale))       
                     (n-items (array-dimension data 1))
                     (n-items-1 (- n-items 1))
                     (item-labels (select (send current-model :variables) selection))
                     (item-variances  (mapcar #'variance (column-list data)))
                     (suma-item-variances (sum item-variances))
                     (scale-variance (variance scale))
                     (scale-std (standard-deviation scale))
                     (pre-impares (* 2 (iseq n-items)))
                     (pares (reverse (set-difference (iseq n-items) pre-impares)))
                     (impares (reverse (set-difference (iseq n-items) pares)))
                     (item-impares  (select (column-list data) impares))
                     (impares-matrix (make-array (list (length impares) nobs) :initial-contents item-impares))
                     (item-pares  (select (column-list data) pares))
                     (pares-matrix (make-array (list (length pares) nobs)  :initial-contents item-pares))
                     (scale-pares (mapcar #'sum (column-list  pares-matrix)))
                     (scale-impares (mapcar #'sum (column-list  impares-matrix)))
                     (split-half  (/ (* 2 (correlation scale-pares scale-impares)) (+ 1 (correlation scale-pares scale-impares))))
                     (item-corr-matrix (correlation-matrix data))
                     (average-correlation (/ (- (sum item-corr-matrix) n-items) ( - (* n-items n-items) n-items)))
                     (left-alpha 1)
                     
                     (prepped-data
                      (/ (normalize (center data) 1) (sqrt (1- nobs))))
                     (corcovmat (matmult (transpose prepped-data) prepped-data))
                     (svd (sv-decomp2 prepped-data)) 
                     (svd (if (< (sum (col (select svd 2) 0)) 0)
                              (list (* -1 (select svd 0))
                                    (select svd 1)
                                    (* -1 (select svd 2))
                                    (select svd 3))
                              svd))
                     (eigenvalues (^ (select svd 1) 2))
                     (eign (select eigenvalues 0))
                     (n (length eigenvalues))
                     (prop (/ eigenvalues (sum eigenvalues)))
                     (maxy (select prop 0))
                     (cum-prop (cumsum prop))
                     
                     (eigenvalues2 (mapcar #' (lambda (k)
                                                (exp 
                                                 (+ 
                                                  -0.130827
                                                  (* -0.444853 k)
                                                  (* -0.008497 (* k k)) 
                                                  (* 0.639462 (log n-items))
                                                  (* (* 0.059901 k) (log Nobs))
                                                  (* -0.078631 (* (log Nobs) (log n-items)))
                                                  (* (* 0.001488 (* k k)) (log Nobs))
                                                  (* (* 0.095875 k) (log n-items))
                                                  (* (* 0.001576 (* k k)) (log n-items))
                                                  (* (* -0.013331 k) (* (log Nobs) (log n-items)))
                                                  (* (* -0.000278 (* k k)) (* (log Nobs) (log n-items)))
                                                  ))) (iseq n-items)))
                     
                     (prop2 (/ eigenvalues2 (sum eigenvalues2)))
                     (maxy2 (select prop2 0))
                     (cum-prop2 (cumsum prop2))
                     
                     
                     (theta (* (/ n-items (- n-items 1)) (- 1 (/ 1 eign))))
                     (theta-function (mapcar #'(lambda (x)  (* (/ n-items (- n-items 1)) (- 1 (/ 1 x))) ) (rseq 1 n-items 50)))
                     (alfa (* 
                            (/ n-items n-items-1)
                            (- 1 (/ suma-item-variances scale-variance))))
                     
                     (rel-pronostico (mapcar #'(lambda (x) (* X (/ alfa  (+ 1 (* (- X 1) alfa))))) (rseq 1 5 50)))
                     (scale-if (column-list (make-array (array-dimensions data)  :initial-contents(mapcar #'- scale  (row-list data)))))
                     
                     (scale-variance-if (mapcar #'variance scale-if))
                     (suma-item-variances-if (mapcar #'(lambda (x) (-  (sum item-variances) x))item-variances))
                     (alfa-if (mapcar #'(lambda (suma-item-variances-if scale-variance-if) (* (/ n-items-1 (- n-items-1 1)) (- 1 (/ suma-item-variances-if scale-variance-if)))) suma-item-variances-if scale-variance-if))
                     )
                (send item-dif&dis :selection selection)
                (send ItemMean :selection selection)
                (send Alfa-ifP :start-buffering)
                (send Alfa-ifP :clear)       
                (send Alfa-ifP :x-axis t t (+ 2 n-items))
                (send Alfa-ifP :y-axis t t 6)
                (send Alfa-ifP :range  0 0 (+ 1 n-items))
                (send Alfa-ifP :add-points  (iseq 1 n-items) alfa-if :point-labels item-labels)
                (send Alfa-ifP :use-color t)
                (send Alfa-ifP :point-color (iseq n-items) 'blue)
                (send Alfa-ifP :showing-labels t)  
                (send Alfa-ifP :redraw)
                (send Alfa-ifP :abline alfa-original 0)
                (send Alfa-ifP :abline alfa 0 :color 'blue)
                (send Alfa-ifP :buffer-to-Screen)    
                
                (send Scree :start-buffering)      
                (send Scree :clear-points)
                (send Scree :clear-lines)
                (send Scree :add-points  (+ 1 (iseq n)) prop)
                (send Scree :add-lines  (list (+ 1 (iseq n)) prop2) :draw nil :color 'dark-green)
                
                (send Scree :range 1 0  (* .1 (ceiling (* 10 maxy))) :draw nil)
                (send Scree :y-axis t t (1+   (ceiling (* 10 maxy))) :draw t)
                (send Scree :showing-labels t)
                (send Scree :point-state 0 'selected)
                (send Scree :adjust-to-data :draw nil)
                (send Scree :add-lines 
                      (list (+ 1 (iseq n)) prop) :draw nil :color 'red)
                (send Scree :point-color (iseq n) 'red)
                
                (mapcar #'(lambda (i)
                            (send Scree :point-label i
                                  (cond
                                    ((> i 0) 
                                     (format nil "~5,4f, ~5,4f, ~5,4f" 
                                             (select prop i) 
                                             (- (select prop (- i 1)) (select prop i) )
                                             (select cum-prop i)))
                                    (t
                                     (format nil "~5,4f" (select prop i))))))
                        (iseq (send Scree :num-points)))
                (send Scree :plot-buttons :new-x nil :new-y nil :mouse-mode t)           (send Scree :redraw)
                (send Scree :buffer-to-Screen)
                (send NqPlot :start-buffering)      
                (send NqPlot :new-plot  scale :reg-line t :variable-labels "Total Scale" :point-labels  nil)            
                (send NqPlot :showing-labels nil)
                (send NqPlot :redraw)
                (send NqPlot :buffer-to-Screen)                
                (send p :start-buffering)
                (send p :clear)
                (send p :range 0 1 n-items)
                (send p :x-axis t t n-items)
                (send p :add-lines 
                      (rseq 1 n-items 50) theta-function)
                (send p :abline theta 0 )
                (send p :redraw)
                (send p :buffer-to-Screen)
                (send plot :start-buffering)
                (send plot :clear)
                (send plot :add-lines 
                      (rseq 1 5 50) rel-pronostico)
                (send plot :abline alfa-original 0)
                (send plot :redraw)
                (send plot :buffer-to-Screen)
                (send SplitScat :start-buffering)
                (send SplitScat :clear-points)
                (send SplitScat :add-points scale-pares scale-impares :point-labels  labels) 
                (send SplitScat :use-color t)
                (send SplitScat :linked t)
                (send SplitScat :adjust-to-data)
                (send SplitScat :point-color (iseq nobs) 'blue)
                (send SplitScat :redraw) 
                (send SplitScat :buffer-to-Screen)
                (send histscale :start-buffering)
                (send histscale :title "Total Scale")
                (send histscale :clear-points)
                (send histscale :add-points scale  :point-labels  labels)
                (send histscale :use-color t)
                (send histscale :point-color (iseq nobs) 'blue)
                (send histscale :linked t)
                (send histscale :adjust-to-data)    
                (send histscale :redraw)
                (send histscale :buffer-to-Screen)
                (send itembox :new-plot  data
                      :variable-labels item-labels
                      :point-labels  labels
                      :connect-points t)
                (send scalebox :new-plot  scale
                      :variable-labels (list "Total score")
                      :point-labels  labels)
                (send split-box :new-plot (list scale-pares scale-impares) 
                      :title "Split Half Box"
                      :point-labels  labels
                      :variable-labels SplitLabel
                      :connect-points t)
                (send CCIbox :new-plot
                      (mapcar #'(lambda (q) (mapcar #'mean (column-list (make-array (list (length (which (= q scaleq))) n-items) :initial-contents (COMBINE (select (row-list data) (which (= q scaleq))))))))(sort-data (remove-duplicates  scaleq :test #'equal)))
                      :title "CCIbox" 
                      :point-labels item-labels 
                      :variable-labels (list "<Perc20" "Perc20-39" "Perc40-59" "Perc60-79" ">=80")
                      :connect-points t)
                )
              ) 
            t)
      )

    (UNLINK-VIEWs CCIbox )
    (send sp  :show-spreadplot)
    )
  )
